<?xml version='1.0' encoding='UTF-8' ?>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:HTML='http://www.w3.org/Profiles/XHTML-transitional' xmlns:dt='urn:schemas-microsoft-com:datatypes'>

	<xsl:output method='html'/>



	<xsl:template match='@* | node()'>

		<xsl:copy><xsl:apply-templates select="@* | node()"/></xsl:copy>

	</xsl:template>

	

	<xsl:strip-space elements="*"/>



	<xsl:template match='/'>

		<xsl:apply-templates select='workspace/mainWindow'/>

	</xsl:template>



	<!-- <xsl:template match='documents'>

		<xsl:apply-templates/>

	</xsl:template> -->



	<xsl:template match='workspace/mainWindow'>

		<xsl:choose>

			<xsl:when test='dock[1]'><xsl:apply-templates select='dock[1]'/></xsl:when>

			<xsl:otherwise><xsl:apply-templates select='main'/></xsl:otherwise>

		</xsl:choose>

	</xsl:template>

	

	<xsl:template match='dock[@position="top"]'>

		<table cellpadding="0" cellspacing="0" width="100%" dockPosition='top'><xsl:call-template name='layoutDoc'/><xsl:apply-templates select='@resizable'/>

			<tr><td _height='{@height}'><xsl:call-template name='layoutNode'>

			</xsl:call-template>

			</td></tr>

			<tr><td><img class='VResize' src='../apt/images/transdot.gif'/></td></tr>

			<tr><td><xsl:choose>

				<xsl:when test='following-sibling::dock'><xsl:apply-templates select='following-sibling::dock[1]'/></xsl:when>

				<xsl:otherwise><xsl:apply-templates select='parent::*/main'/></xsl:otherwise>

			</xsl:choose></td></tr>

		</table>

	</xsl:template>	

	

	<xsl:template match='dock[@position="left"]'>

		<table cellpadding="0" cellspacing="0" height='100%' dockPosition='left'><xsl:call-template name='layoutDoc'/><xsl:apply-templates select='@resizable'/>

			<tr><td _width='{@width}'><xsl:call-template name='layoutNode'>

			</xsl:call-template>

			</td>

			<td><img class='HResize' src='../apt/images/transdot.gif'/></td>

			<td><xsl:choose>

				<xsl:when test='following-sibling::dock'><xsl:apply-templates select='following-sibling::dock[1]'/></xsl:when>

				<xsl:otherwise><xsl:apply-templates select='parent::*/main'/></xsl:otherwise>

			</xsl:choose></td>

			</tr>

		</table>

	</xsl:template>	



	<xsl:template match='dock[@position="right"]'>

		<table cellpadding="0" cellspacing="0" height='100%' dockPosition='right'><xsl:call-template name='layoutDoc'/><xsl:apply-templates select='@resizable'/>

			<tr><td><xsl:choose>

				<xsl:when test='following-sibling::dock'><xsl:apply-templates select='following-sibling::dock[1]'/></xsl:when>

				<xsl:otherwise><xsl:apply-templates select='parent::*/main'/></xsl:otherwise>

			</xsl:choose></td>

			<td><img class='HResize' src='../apt/images/transdot.gif'/></td>

			<td _width='{@width}'><xsl:call-template name='layoutNode'>

			</xsl:call-template>

			</td>

			</tr>

		</table>

	</xsl:template>	



	<xsl:template match='dock[@position="bottom"]'>

		<table cellpadding="0" cellspacing="0" dockPosition='bottom' width='100%'><xsl:call-template name='layoutDoc'/><xsl:apply-templates select='@resizable'/>

			<tr><td><xsl:choose>

				<xsl:when test='following-sibling::dock'><xsl:apply-templates select='following-sibling::dock[1]'/></xsl:when>

				<xsl:otherwise><xsl:apply-templates select='parent::*/main'/></xsl:otherwise>

			</xsl:choose></td></tr>

			<tr><td><img class='VResize' src='../apt/images/transdot.gif'/></td></tr>

			<tr><td _height='{@height}'><xsl:call-template name='layoutNode'>

			</xsl:call-template>

			</td>

			</tr>

		</table>

	</xsl:template>	



	<xsl:template match='mainWindow/main'>

		<div class='mdiMain' dockPosition='mdiMain'><xsl:call-template name='layoutDoc'/><xsl:call-template name='layoutNode'>

			</xsl:call-template></div>

	</xsl:template>	

	

	<xsl:template name='layoutNode'>

		<xsl:choose>

			<xsl:when test='dock'>

				<xsl:apply-templates select='dock[1]'/>

			</xsl:when>

			<xsl:otherwise>

				<div style="display:none;">

					<xsl:apply-templates select='@viewURL | @width | @height'/>

				</div>

			</xsl:otherwise>

		</xsl:choose>

	</xsl:template>



	<xsl:template name='layoutDoc'>

		<xsl:attribute name='docNode'><xsl:for-each select='ancestor-or-self::*'>/*[<xsl:value-of select='count(preceding-sibling::*)'/>]</xsl:for-each></xsl:attribute>

	</xsl:template>

</xsl:stylesheet>

